// Kbdru_Russian_pkf.txt
/*
	Copyright  1995-2006, The AROS Development Team. All rights reserved.
	$Id: pc104_ua.c,v 1.1 2011/01/19 10:18:58 tokai Exp $
	
	Desc: Ukrainian PC104 Keymap
	Lang: English

	UCS tables by scf
*/

#include <devices/keymap.h>

#define	VERSION		51
#define	REVISION	6
#define	KMDESC		"Ukrainian keyboard with 104 keys"
#define	KMID		"pc104_ua 51.6"
#define KMNAME		"pc104_ua"
#define KMLANG      "Ukrajinska"
#define KMLANGINT   "Ukrainian"
#define KMCODEPAGE  "Windows-1251"

#define CONST const

extern CONST char  keymapname[];

extern CONST UBYTE lokeymaptypes[];
extern CONST IPTR  lokeymap[];
extern CONST UBYTE locapsable[];
extern CONST UBYTE lorepeatable[];

extern CONST UBYTE hikeymaptypes[];
extern CONST IPTR  hikeymap[];
extern CONST UBYTE hicapsable[];
extern CONST UBYTE hirepeatable[];

static const struct Resident ROMTag;

struct ExtendedKeyMapNode km =
{
	{
	NULL, NULL, NT_EXTENDED, 'E', (char*) keymapname
	},
	{
	(UBYTE *)lokeymaptypes,
	(IPTR  *)lokeymap,
	(UBYTE *)locapsable,
	(UBYTE *)lorepeatable,
	(UBYTE *)hikeymaptypes,
	(IPTR  *)hikeymap,
	(UBYTE *)hicapsable,
	(UBYTE *)hirepeatable
	},
	0,
	(struct Resident *)&ROMTag,
	0
};

CONST char keymapname[] = KMNAME;

#undef N
#undef S
#undef A
#undef C
#undef D
#undef V
#undef ST
#undef NOP

#define N   KC_NOQUAL
#define S   KCF_SHIFT
#define A   KCF_ALT
#define C   KCF_CONTROL
#define D   KCF_DEAD
#define V   KC_VANILLA
#define ST  KCF_STRING
#define NOP KCF_NOP

#define EUR 0x88 /* ISO 8859-15: Euro = 164 = 0xA4) */

STATIC CONST UBYTE lokeymaptypes[] =
{
	S, 		/* 00 */
	S, 		/* 01 */
	S|A,	/* 02 */
	S|A,	/* 03 */
	S|A,	/* 04 */
	S,		/* 05 */
	S,		/* 06 */
	S,	    	/* 07 */
	S,	    	/* 08 */
	S,	    	/* 09 */
	S,	    	/* 0A */
	S,	    	/* 0B */
	S, 		/* 0C */
	N, 		/* 0D */
	N, 		/* 0E */
	S|A, 	/* 0F */
	V,	 	/* 10 q */
	V,	 	/* 11 w */
	V,	 	/* 12 e */
	V,	 	/* 13 r */
	V,	 	/* 14 t */
	V,	 	/* 15 z */
	V,	 	/* 16 u */
	V,	 	/* 17 i */
	V,	 	/* 18 o */
	V,	 	/* 19 p */
	S, 		/* 1A */
	S|A, 	/* 1B */
	S|A, 	/* 1C */
	S|A, 	/* 1D */
	S|A, 	/* 1E */
	S|A, 	/* 1F */
	V, 		/* 20 a */
	V, 		/* 21 s */
	V, 		/* 22 d */
	V, 		/* 23 f */
	V, 		/* 24 g */
	V, 		/* 25 h */
	V, 		/* 26 j */
	V, 		/* 27 k */
	V,	 	/* 28 l */
	S, 		/* 29 */
	S, 		/* 2A */
	S, 		/* 2B */
	N, 		/* 2C */
	N, 		/* 2D */
	N, 		/* 2E */
	N, 		/* 2F */
	S|A,	/* 30 */
	V,	 	/* 31 y */
	V,	 	/* 32 x */
	V,	 	/* 33 c */
	V,	 	/* 34 v */
	V,	 	/* 35 b */
	V,	 	/* 36 n */
	V,	 	/* 37 m */
	S|A,	/* 38 */
	S|A,	/* 39 */
	S, 		/* 3A */
	N, 		/* 3B */
	N, 		/* 3C */
	N, 		/* 3D */
	N, 		/* 3E */
	N, 		/* 3F */
};

STATIC CONST UBYTE hikeymaptypes[] =
{
	N, 		/* 40 SPACE */
	N, 		/* 41 BACKSPACE */
	ST|S,	/* 42 TAB */
	N,		/* 43 ENTER */
	C,		/* 44 RETURN */
	A, 	 	/* 45 ESCAPE */
	N, 	 	/* 46 DEL  */
	ST|S,	/* 47 INSERT ?? */
	ST|S,	/* 48 PAGE UP ?? */
	ST|S,	/* 49 PAGE DOWN ?? */
	N,		/* 4A NUMERIC PAD - */
	ST|S,	/* 4B F11 ?? */
	ST|S, 	/* 4C CURSORUP*/
	ST|S, 	/* 4D CURSORDOWN */
	ST|S, 	/* 4E CURSORRIGHT */
	ST|S, 	/* 4F CURSORLEFT */
	ST|S, 	/* 50 F1 */
	ST|S, 	/* 51 F2 */
	ST|S, 	/* 52 F3 */
	ST|S, 	/* 53 F4 */
	ST|S, 	/* 54 F5 */
	ST|S, 	/* 55 F6 */
	ST|S, 	/* 56 F7 */
	ST|S, 	/* 57 F8 */
	ST|S, 	/* 58 F9 */
	ST|S, 	/* 59 F10 */
	NOP, 	/* 5A NUMLOCK */
	N, 		/* 5B NUMPAD ) */
	N, 		/* 5C NUMPAD / */
	N, 		/* 5D NUMPAD * */
	N, 		/* 5E NUMPAD + */
	ST,		/* 5F HELP */
	NOP,	/* 60 LEFT SHIFT*/
	NOP, 	/* 61 RIGHT SHIFT */
	NOP, 	/* 62 CAPS LOCK */
	NOP,	/* 63 CONTROL */
	NOP,	/* 64 LALT */
	NOP,	/* 65 RALT */
	NOP,	/* 66 LCOMMAND */
	NOP, 	/* 67 RCOMMAND */
	NOP, 	/* 68 LEFT MOUSE BUTTON*/
	NOP,	/* 69 RIGHT MOUSE BUTTON */
	NOP,	/* 6A MIDDLE MOUSE BUTTON */
	NOP,	/* 6B */
	NOP,	/* 6C */
	NOP,	/* 6D */
	ST|A,	/* 6E PAUSE/BREAK ??*/
	ST|S, 	/* 6F F12 ?? */
	ST|C, 	/* 70 HOME ?? */
	ST|C, 	/* 71 END ?? */
	NOP, 	/* 72 */
	NOP, 	/* 73 */
	NOP, 	/* 74 */
	NOP, 	/* 75 */
	NOP, 	/* 76 */
	NOP, 	/* 77 */
	NOP, 	/* 78 */
	NOP, 	/* 79 */
	NOP, 	/* 7A */
	NOP, 	/* 7B */
	NOP, 	/* 7C */
	NOP, 	/* 7D */
	NOP, 	/* 7E */
	NOP 	/* 7F */
};

#undef N
#undef S
#undef A
#undef C
#undef D
#undef V
#undef ST
#undef NOP

#undef STRING
#undef DEAD
#undef BYTES

#define STRING(x) (IPTR)x
#define DEAD(x)	  (IPTR)x
#define BYTES(b0, b1, b2, b3) \
	(((UBYTE)b0)<<24) | (((UBYTE)b1)<<16) | (((UBYTE)b2)<<8) | (((UBYTE)b3)<<0)

STATIC CONST IPTR lokeymap[] =
{
	/*---- 1st QWERTY row - 0x00 to 0x0F */
	BYTES(0xA6,0x7E,0xA8,0xB8),
	BYTES(0xB9,0xB1,'!' ,'1' ),
	BYTES(0xB2,'@' ,0x22,'2' ),
	BYTES(0xB3,0xA1,0xB9,'3' ),
	BYTES(0xBC,'$' ,';' ,'4' ),
	BYTES(0xBD,0xBF,'%' ,'5' ),
	BYTES(0xBE,0x5E,':' ,'6' ),
	BYTES(0x83,'&' ,'?' ,'7' ),
	BYTES(0xAB,0x8B,'*' ,'8' ),
	BYTES(0xBB,0x9B,'(' ,'9' ),
	BYTES(0x84,0x82,')' ,'0' ),
	BYTES(0x93,0x91,'_' ,'-' ),
	BYTES(0x94,0x92,'+' ,'=' ),
	BYTES(0xA6,0x7E,0xA8,0xB8),
	BYTES(0,   0,   0,   0  ),
	BYTES('0', '0', '0', '0'),
	/*---- 2nd QWERTY row - 0x10 to 0x1F */
	BYTES('Q' ,'q' ,0xC9,0xE9),
	BYTES('W' ,'w' ,0xD6,0xF6),
	BYTES('E' ,'e' ,0xD3,0xF3),
	BYTES('R' ,'r' ,0xCA,0xEA),
	BYTES('T' ,'t' ,0xC5,0xE5),
	BYTES('Y' ,'y' ,0xCD,0xED),
	BYTES('U' ,'u' ,0xC3,0xE3),
	BYTES('I' ,'i' ,0xD8,0xF8),
	BYTES('O' ,'o' ,0xD9,0xF9),
	BYTES('P' ,'p' ,0xC7,0xE7),
	BYTES('{' ,'[' ,0xD5,0xF5),
	BYTES('}' ,']' ,0xAF,0xBF),
	BYTES(0,   0,   0,   0  ),
	BYTES('1', '1', '1', '1'),
	BYTES('2', '2', '2', '2'),
	BYTES('3', '3', '3', '3'),
	/*---- 3rd QWERTY row - 0x20 to 0x2F */
	BYTES('A' ,'a' ,0xD4,0xF4),
	BYTES('S' ,'s' ,0xB2,0xB3),
	BYTES('D' ,'d' ,0xC2,0xE2),
	BYTES('F' ,'f' ,0xC0,0xE0),
	BYTES('G' ,'g' ,0xCF,0xEF),
	BYTES('H' ,'h' ,0xD0,0xF0),
	BYTES('J' ,'j' ,0xCE,0xEE),
	BYTES('K' ,'k' ,0xCB,0xEB),
	BYTES('L' ,'l' ,0xC4,0xE4),
	BYTES(':' ,';' ,0xC6,0xE6),
	BYTES(0x22,0x27,0xAA,0xBA),
	BYTES(0x7C,0x5C,0x2F,0x5C),
	BYTES(0,   0,   0,   0  ),
	BYTES('4', '4', '4', '4'),
	BYTES('5', '5', '5', '5'),
	BYTES('6', '6', '6', '6'),
	/*---- 4th QWERTY row - 0x30 to 0x3F */
	BYTES('>' ,'<' ,0xA5,0xB4),
	BYTES('Z' ,'z' ,0xDF,0xFF),
	BYTES('X' ,'x' ,0xD7,0xF7),
	BYTES('C' ,'c' ,0xD1,0xF1),
	BYTES('V' ,'v' ,0xCC,0xEC),
	BYTES('B' ,'b' ,0xC8,0xE8),
	BYTES('N' ,'n' ,0xD2,0xF2),
	BYTES('M' ,'m' ,0xDC,0xFC),
	BYTES('<' ,',' ,0xC1,0xE1),
	BYTES('>' ,'.' ,0xDE,0xFE),
	BYTES('?' ,0x2F,',' ,'.' ),
	BYTES(0,   0,   0,   0  ),
	BYTES(',', '.', ',', '.'),
	BYTES('7', '7', '7', '7'),
	BYTES('8', '8', '8', '8'),
	BYTES('9', '9', '9', '9'),
};

#include "standard.h"

STATIC CONST IPTR hikeymap[] =
{
	BYTES(' ', ' ', ' ', ' '),	/* 40 */
	BYTES(8, 8, 8, 8),		/* 41 BACKSPACE*/
	STRING(tab_descr),		/* 42 TAB */
	BYTES(13, 13, 13, 13),	/* 43 ENTER */
	BYTES(0, 0, 10, 13),	/* 44 RETURN */
	BYTES(0, 0, 0x9B, 27),	/* 45 ESCAPE */
	BYTES(127, 127, 127, 127),	/* 46 DEL */
	STRING(insert_descr),	/* 47 INSERT ?? */
	STRING(pageup_descr),	/* 48 PAGEUP ?? */
	STRING(pagedown_descr),	/* 49 PAGEDOWN ?? */
	BYTES('-', '-', '-', '-'),	/* 4A NUMPAD - */
	STRING(f11_descr), 		/* 4B F11 ?? */
	STRING(up_descr),		/* 4C CURSOR UP*/
	STRING(down_descr),		/* 4D CURSOR DOWN*/
	STRING(right_descr),	/* 4E CURSOR RIGHT */
	STRING(left_descr),		/* 4F CURSOR LEFT */
	STRING(f1_descr),		/* 50 F1 */
	STRING(f2_descr),		/* 51 */
	STRING(f3_descr),		/* 52 */
	STRING(f4_descr),		/* 53 */
	STRING(f5_descr),		/* 54 */
	STRING(f6_descr),		/* 55 */
	STRING(f7_descr),		/* 56 */
	STRING(f8_descr),		/* 57 */
	STRING(f9_descr),		/* 58 */
	STRING(f10_descr),		/* 59 */
	BYTES(0, 0, 0, 0),		/* 5A */
	BYTES('/', '/', '/', '/'),	/* 5B */
	BYTES('*', '*', '*', '*'),	/* 5C */
	BYTES('-', '-', '-', '-'),	/* 5D */
	BYTES('+', '+', '+', '+'),	/* 5E */
	STRING(help_descr),		/* 5F HELP */
	BYTES(0, 0, 0, 0),		/* 60 */
	BYTES(0, 0, 0, 0),		/* 61 */
	BYTES(0, 0, 0, 0),		/* 62 */
	BYTES(0, 0, 0, 0),		/* 63 */
	BYTES(0, 0, 0, 0),		/* 64 */
	BYTES(0, 0, 0, 0),		/* 65 */
	BYTES(0, 0, 0, 0),		/* 66 */
	BYTES(0, 0, 0, 0),		/* 67 */
	BYTES(0, 0, 0, 0),		/* 68 */
	BYTES(0, 0, 0, 0),		/* 69 */
	BYTES(0, 0, 0, 0),		/* 6A */
	BYTES(0, 0, 0, 0),		/* 6B */
	BYTES(0, 0, 0, 0),		/* 6C */
	BYTES(0, 0, 0, 0),		/* 6D */
	STRING(pausebreak_descr),	/* 6E PAUSE/BREAK ?? */
	STRING(f12_descr),		/* 6F F12 ?? */
	STRING(home_descr),		/* 70 HOME ?? */
	STRING(end_descr),		/* 71 END ?? */
	BYTES(0, 0, 0, 0),		/* 72 */
	BYTES(0, 0, 0, 0),		/* 73 */
	BYTES(0, 0, 0, 0),		/* 74 */
	BYTES(0, 0, 0, 0),		/* 75 */
	BYTES(0, 0, 0, 0),		/* 76 */
	BYTES(0, 0, 0, 0),		/* 77 */
	BYTES(0, 0, 0, 0),		/* 78 */
	BYTES(0, 0, 0, 0),		/* 79 */
	BYTES(0, 0, 0, 0),		/* 7A */
	BYTES(0, 0, 0, 0),		/* 7B */
	BYTES(0, 0, 0, 0),		/* 7C */
	BYTES(0, 0, 0, 0),		/* 7D */
	BYTES(0, 0, 0, 0),		/* 7E */
	BYTES(0, 0, 0, 0),		/* 7F */
};

#undef SETBITS

#define SETBITS(b0, b1, b2, b3, b4, b5, b6, b7) \
	(b0<<0)|(b1<<1)|(b2<<2)|(b3<<3)|(b4<<4)|(b5<<5)|(b6<<6)|(b7<<7)
	
STATIC CONST UBYTE locapsable[] =
{
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 00 - 07 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 08 - 0F */
	
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 10 - 17 */
	SETBITS(1, 1, 1, 1, 0, 0, 0, 0),	/* 18 - 1F */
	
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 20 - 27 */
	SETBITS(1, 1, 1, 0, 0, 0, 0, 0),	/* 28 - 2F */
	
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 30 - 37 */
	SETBITS(1, 1, 0, 0, 0, 0, 0, 0)	/* 38 - 3F */
};

STATIC CONST UBYTE hicapsable[] =
{
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 40 - 47 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 48 - 4F */
	
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 50 - 57 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 58 - 5F */
	
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 60 - 67 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 68 - 6F */
	
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 70 - 77 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0)	/* 78 - 7F */
};

STATIC CONST UBYTE lorepeatable[] =
{
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 00 - 07 */
	SETBITS(1, 1, 1, 1, 1, 1, 0, 1),	/* 08 - 0F */
	
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 10 - 17 */
	SETBITS(1, 1, 1, 1, 0, 1, 1, 1),	/* 18 - 1F */
	
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 20 - 27 */
	SETBITS(1, 1, 1, 1, 0, 1, 1, 1),	/* 28 - 2F */
	
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 30 - 37 */
	SETBITS(1, 1, 1, 0, 1, 1, 1, 1)	/* 38 - 3F */
};

STATIC CONST UBYTE hirepeatable[] =
{
	SETBITS(1, 1, 1, 0, 0, 0, 1, 0),	/* 40 - 47 */
	SETBITS(1, 1, 0, 0, 1, 1, 1, 1),	/* 48 - 4F */
	
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 50 - 57 */
	SETBITS(0, 0, 1, 1, 1, 1, 1, 0),	/* 58 - 5F */
	
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 60 - 67 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 68 - 6F */
	
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 70 - 77 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0)	/* 78 - 7F */
};

#define HAVE_UNICODE_CONVTABLE 1
#define HAVE_CHARSET_CONVTABLE 1

STATIC CONST ULONG unicodetable[] =
{
   // 0x80 - 0x8F
   0x0402, 0x0403, 0x201A, 0x0453, 0x201E, 0x2026, 0x2020, 0x2021,
   0x20AC, 0x2030, 0x0409, 0x2039, 0x040A, 0x040C, 0x040B, 0x040F,

   // 0x90 - 0x9F
   0x0452, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014,
   0x0000, 0x2122, 0x0459, 0x203A, 0x045A, 0x045C, 0x045B, 0x045F,

   // 0xA0 - 0xAF
   0x00A0, 0x040E, 0x045E, 0x0408, 0x00A4, 0x0490, 0x00A6, 0x00A7,
   0x0401, 0x00A9, 0x0404, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x0407,

   // 0xB0 - 0xBF
   0x00B0, 0x00B1, 0x0406, 0x0456, 0x0491, 0x00B5, 0x00B6, 0x00B7,
   0x0451, 0x2116, 0x0454, 0x00BB, 0x0458, 0x0405, 0x0455, 0x0457,

   // 0xC0 - 0xCF
   0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
   0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F,

   // 0xD0 - 0xDF
   0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
   0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,

   // 0xE0 - 0xEF
   0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
   0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,

   // 0xF0 - 0xFF
   0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
   0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F
};

STATIC CONST struct UCS4_ConvTable convtable =
{
   0x80,
   0xff,
   unicodetable
};


STATIC CONST UBYTE chartable01[] =
{
   // 0x00A0
   0xA0
};

STATIC CONST UBYTE chartable02[] =
{
   // 0x00A4
	0xA4
};

STATIC CONST UBYTE chartable03[] =
{
   // 0x00A6 - 0x00A7
   0xA6, 0xA7
};

STATIC CONST UBYTE chartable04[] =
{
   // 0x00A9
   0xA9
};

STATIC CONST UBYTE chartable05[] =
{
   // 0x00AB - 0x00B1
   0xAB, 0xAC, 0xAD, 0xAE, 0xB0, 0xB1, 0xB5, 0xB6, 0xB7
};

STATIC CONST UBYTE chartable06[] =
{
   // 0x00BB
   0xBB
};

STATIC CONST UBYTE chartable07[] =
{
   // 0x0401 - 0x040C
   0xA8, 0x80, 0x81, 0xAA, 0xBD, 0xB2, 0xAF, 0xA3, 0x8A, 0x8C, 0x8E, 0x8D
};

STATIC CONST UBYTE chartable08[] =
{
   // 0x040E - 0x040F
   0xA1, 0x8F
};

STATIC CONST UBYTE chartable09[] =
{
   // 0x0410 - 0x045C
   0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
   0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
   0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
   0xD8, 0xD9, 0xAF, 0xB2, 0xDC, 0xAA, 0xDE, 0xDF,
   0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
   0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
   0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
   0xF8, 0xF9, 0xBF, 0xB3, 0xFC, 0xBA, 0xFE, 0xFF,
   0xB8, 0x90, 0x83, 0xBA, 0xBE, 0xB3, 0xBF, 0xBC,
   0x9A, 0x9C, 0x9E, 0x9D
};

STATIC CONST UBYTE chartable10[] =
{
   // 0x045E - 0x045F
   0xA2, 0x9F
};

STATIC CONST UBYTE chartable11[] =
{
   // 0x0490 - 0x0491
   0xA5, 0xB4
};

STATIC CONST UBYTE chartable12[] =
{
   // 0x2013 - 0x2014
   0x96, 0x97
};

STATIC CONST UBYTE chartable13[] =
{
   // 0x2018 - 0x201A
   0x91, 0x92, 0x82
};

STATIC CONST UBYTE chartable14[] =
{
   // 0x201C - 0x201E
   0x93, 0x94, 0x84
};

STATIC CONST UBYTE chartable15[] =
{
   // 0x2020 - 0x2022
   0x86, 0x87, 0x95
};

STATIC CONST UBYTE chartable16[] =
{
   // 0x2026
   0x85
};

STATIC CONST UBYTE chartable17[] =
{
   // 0x2030
   0x89
};

STATIC CONST UBYTE chartable18[] =
{
   // 0x2039 - 0x203A
   0x8B, 0x9B
};

STATIC CONST UBYTE chartable19[] =
{
   // 0x20AC
   0x88
};

STATIC CONST UBYTE chartable20[] =
{
   // 0x2116
   0xB9
};

STATIC CONST UBYTE chartable21[] =
{
   // 0x2122
   0x99
};

STATIC CONST struct UCS4_CharsetConvTable convtable2 =
{
   NULL,

   {
	   { 0x0a0, 0x0a0, chartable01 },
	   { 0x0a4, 0x0a4, chartable02 },
	   { 0x0a6, 0x0a6, chartable03 },
	   { 0x0a9, 0x0a9, chartable04 },
	   { 0x0ab, 0x0b1, chartable05 },
	   { 0x0bb, 0x0bb, chartable06 },
	   { 0x401, 0x40c, chartable07 },
	   { 0x40e, 0x40f, chartable08 },
	   { 0x410, 0x45c, chartable09 },
	   { 0x45e, 0x45f, chartable10 },
	   { 0x490, 0x491, chartable11 },
	   { 0x2013, 0x2014, chartable12 },
	   { 0x2018, 0x201a, chartable13 },
	   { 0x201c, 0x201e, chartable14 },
	   { 0x2020, 0x2022, chartable15 },
	   { 0x2026, 0x2026, chartable16 },
	   { 0x2030, 0x2030, chartable17 },
	   { 0x2039, 0x203a, chartable18 },
	   { 0x20ac, 0x20ac, chartable19 },
	   { 0x2116, 0x2116, chartable20 },
	   { 0x2122, 0x2122, chartable21 },
	   { 0x000, 0x000, NULL }
   }
};

#include "query.c"
